<?php

//Theme Option
include_once( ZOZO_CORE_ADMIN . '/theme-options.php');

/**
 * Include Widgets
 */
include_once( ZOZO_CORE_DIR . 'widgets/facebook_like_widget.php');
include_once( ZOZO_CORE_DIR . 'widgets/twitter-widget/tweets_widget.php');
include_once( ZOZO_CORE_DIR . 'widgets/call_to_action_widget.php');
include_once( ZOZO_CORE_DIR . 'widgets/flickr_widget.php');
include_once( ZOZO_CORE_DIR . 'widgets/instagram_widget.php');
include_once( ZOZO_CORE_DIR . 'widgets/mailchimp_widget.php');
include_once( ZOZO_CORE_DIR . 'widgets/popular_posts_widget.php');
include_once( ZOZO_CORE_DIR . 'widgets/category_posts_widget.php');
include_once( ZOZO_CORE_DIR . 'widgets/tabs_widget.php');
include_once( ZOZO_CORE_DIR . 'widgets/counters_widget.php');
include_once( ZOZO_CORE_DIR . 'widgets/social_link_widget.php');
add_filter('widget_text', 'do_shortcode');

/* =========================================================
 * Send Email via Ajax when contact form Submitted
 * ========================================================= */

add_action('wp_ajax_zozo_sendmail', 'zozo_contact_send_mail');
add_action('wp_ajax_nopriv_zozo_sendmail', 'zozo_contact_send_mail');

if( ! function_exists( "zozo_contact_send_mail" ) ) {

	function zozo_contact_send_mail() {
	
		global $zozo_options;
	
	   	$sendto = $zozo_options['zozo_contact_email'];
		
		if( $sendto == '' ) {
			$sendto = get_bloginfo('admin_email');
		}
		
		// Get Name value from submitted form
		if( $_POST['contact_name'] != '' ) {
			$name = trim($_POST['contact_name']);
		}
		
		// Get Email id from submitted form
		$email = trim($_POST['contact_email']);
		
		// Get Phone number from submitted form
		if( $_POST['contact_phone'] != '' ) {		
			$phone = trim($_POST['contact_phone']);
		}
		
		// Get Subject from submitted form
		if( $_POST['contact_subject'] != '' ) {
			$subject = trim($_POST['contact_subject']);
		} else {
			$subject = esc_html__('Contact Message From ', 'zozothemes-core') . $name;
		}
		
		// Get Message from submitted form
		$message = trim($_POST['contact_message']);
		
		$name_label = $zozo_options['zozo_labels_name'] ? $zozo_options['zozo_labels_name'] : esc_html__('Name', 'zozothemes-core');
		$email_label = $zozo_options['zozo_labels_email'] ? $zozo_options['zozo_labels_email'] : esc_html__('Email', 'zozothemes-core');
		$subject_label = $zozo_options['zozo_labels_subject'] ? $zozo_options['zozo_labels_subject'] : esc_html__('Subject', 'zozothemes-core');
		$phone_label = $zozo_options['zozo_labels_phone'] ? $zozo_options['zozo_labels_phone'] : esc_html__('Phone Number', 'zozothemes-core');
		$message_label = $zozo_options['zozo_labels_message'] ? $zozo_options['zozo_labels_message'] : esc_html__('Message', 'zozothemes-core');	
		
		$success_msg = $zozo_options['zozo_contact_form_success'];
		$error_msg = $zozo_options['zozo_contact_form_error'];
		
		$success_msg = str_replace( "{name}", $name, $success_msg );
		$error_msg = str_replace( "{name}", $name, $error_msg );
			
		$body = "<p>$name_label: $name</p>";
		$body .= "<p>$email_label: $email</p>";
		$body .= "<p>$phone_label: $phone</p>";
		$body .= "<p>$subject_label: $subject</p>";
		$body .= "<p>$message_label: $message</p>";
		
		$headers = "MIME-Version: 1.0" . "\r\n";
		$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
		
		$headers .= 'From: ' . esc_attr( $name ) . ' <' . esc_attr( $email ) . '>' . "\r\n";
		$headers .= 'Reply-To: ' . esc_attr( $name ) . ' <' . esc_attr( $email ) . '>' . "\r\n";

		if( wp_mail($sendto, $subject, $body, $headers) ) {
			$msg_array = array( 'status' => 'true', 'data' => $success_msg );
			echo json_encode($msg_array);
		} else {
			$msg_array = array( 'status' => 'false', 'data' => $error_msg );
			echo json_encode($msg_array);
		}
		die();
	}
	
}

function mist_get_server_details( $str ){
	return $_SERVER[$str];
}

// Remove Plugin Shortcode and Register Theme Shortcode for EPL
add_action( 'after_setup_theme', 'remove_epl_listing_shortcode', 10 );
function remove_epl_listing_shortcode() {
    remove_shortcode( 'listing' );
	add_shortcode( 'listing', 'zozo_epl_shortcode_listing' );
}


// Add shortcode
add_shortcode('year', 'zozo_year_shortcode');

add_shortcode( 'zozo_vc_blog', 'zozo_vc_blog_shortcode' );
add_shortcode( 'zozo_vc_woo_product_slider', 'zozo_vc_woo_product_slider_shortcode' );
add_shortcode( 'zozo_vc_twitter_slider', 'zozo_vc_twitter_slider_shortcode' );
add_shortcode( 'zozo_vc_testimonials_slider', 'zozo_vc_testimonials_slider_shortcode' );
add_shortcode( 'zozo_vc_testimonials_grid', 'zozo_vc_testimonials_grid_shortcode' );
add_shortcode( 'zozo_vc_team_slider', 'zozo_vc_team_slider_shortcode' );
add_shortcode( 'zozo_vc_team_list', 'zozo_vc_team_list_shortcode' );
add_shortcode( 'zozo_vc_team_grid', 'zozo_vc_team_grid_shortcode' );
add_shortcode( 'zozo_vc_service_box', 'zozo_vc_service_box_shortcode' );
add_shortcode( 'zozo_vc_section_title', 'zozo_vc_section_title_shortcode' );
add_shortcode( 'zozo_vc_search_form', 'zozo_vc_search_form_shortcode' );
add_shortcode( 'zozo_vc_pricing_table', 'zozo_vc_pricing_table_shortcode' );
add_shortcode( 'zozo_vc_portfolio_slider', 'zozo_vc_portfolio_slider_shortcode' );
add_shortcode( 'zozo_vc_portfolio_grid', 'zozo_vc_portfolio_grid_shortcode' );
add_shortcode( 'zozo_vc_mailchimp_form', 'zozo_vc_mailchimp_form_shortcode' );
add_shortcode( 'zozo_vc_list_item', 'zozo_vc_list_item_shortcode' );
add_shortcode( 'zozo_vc_latest_posts', 'zozo_vc_latest_posts_shortcode' );
add_shortcode( 'zozo_vc_icons', 'zozo_vc_icons_shortcode' );
add_shortcode( 'zozo_vc_google_map', 'zozo_vc_google_map_shortcode' );
add_shortcode( 'zozo_vc_feature_box', 'zozo_vc_feature_box_shortcode' );
add_shortcode( 'zozo_vc_events_list', 'zozo_vc_events_list_shortcode' );
add_shortcode( 'zozo_vc_edd_list', 'zozo_vc_edd_list_shortcode' );
add_shortcode( 'zozo_vc_day_counter', 'zozo_vc_day_counter_shortcode' );
add_shortcode( 'zozo_vc_counters', 'zozo_vc_counters_shortcode' );
add_shortcode( 'zozo_vc_content_carousel', 'zozo_vc_content_carousel_shortcode' );
add_shortcode( 'zozo_vc_contact_info', 'zozo_vc_contact_info_shortcode' );
add_shortcode( 'zozo_vc_contact_form', 'zozo_vc_contact_form_shortcode' );
add_shortcode( 'zozo_vc_clients_slider', 'zozo_vc_clients_slider_shortcode' );
add_shortcode( 'zozo_vc_circle_counter', 'zozo_vc_circle_counter_shortcode' );