<?php
defined( 'ABSPATH' ) or die( 'You cannot access this script directly' );

/* ================================================
 * Importer
 * ================================================ */

function mist_get_server_files( $url ){
	$args = array( 'timeout' => 3000 );
	$response = wp_remote_get($url, $args);
	$data = wp_remote_retrieve_body($response);
	return $data;
}

class Zozo_Import {
	
	public $message = "";
	public function __construct(){

	}
	
	public static function mist_credentials(){
		/* you can safely run request_filesystem_credentials() without any issues and don't need to worry about passing in a URL */
		$creds = request_filesystem_credentials(site_url() . '/wp-admin/', '', false, false, array());
	
		/* initialize the API */
		if ( ! WP_Filesystem($creds) ) {
			return false;
		}
		global $wp_filesystem;
		return $wp_filesystem;
	}
	
	public function zozo_import_content( $file ) {

        if ( !defined('WP_LOAD_IMPORTERS') ) define('WP_LOAD_IMPORTERS', true);
		require_once ABSPATH . 'wp-admin/includes/import.php';
	
		$importer_error = false;
		if ( !class_exists( 'WP_Importer' ) ) {
			$class_wp_importer = ABSPATH . 'wp-admin/includes/class-wp-importer.php';
			if ( file_exists( $class_wp_importer ) ){
				require_once($class_wp_importer);
			} else {
				$importer_error = true;
			}
		}
		
		if ( !class_exists( 'WP_Import' ) ) {
			$class_wp_import = dirname( __FILE__ ) .'/wordpress-importer.php';
			if ( file_exists( $class_wp_import ) ){
				require_once($class_wp_import);
			}else
				$importer_error = true;
		}

		if($importer_error){
			echo "Error on import";
		} else {
			if ( !class_exists( 'WP_Import' ) ) {
				echo esc_html__("WP_Import Problem", "mist");
			}else{			
				
				$wp_import = new WP_Import();
				set_time_limit(0);
				$wp_import->fetch_attachments = true;
				
				ob_start();
				$wp_import->import( $file );
				ob_end_clean();				
				
			}
		}
		
    }
	
	public function zozo_import_widgets($widgets, $sidebars) {
		if( $sidebars ) {
        	$this->zozo_import_custom_sidebars($sidebars);
		}
		
        $this->zozo_import_sidebars_widgets( $widgets );
        $this->message = __("Widgets imported successfully", "mist");
    }
	
	public static function zozo_get_available_widgets() {
		global $wp_registered_widget_controls;
		$widget_controls = $wp_registered_widget_controls;
		$available_widgets = array();
		foreach ( $widget_controls as $widget ) {
			if ( ! empty( $widget['id_base'] ) && ! isset( $available_widgets[$widget['id_base']] ) ) { // no dupes
				$available_widgets[$widget['id_base']]['id_base'] = $widget['id_base'];
				$available_widgets[$widget['id_base']]['name'] = $widget['name'];
			}
		}
		return $available_widgets;
	}
	
	public static function zozo_widgets_import_process( $data ) {
	
		global $wp_registered_sidebars;
		// Get all available widgets site supports
		$available_widgets = self::zozo_get_available_widgets();
		// Get all existing widget instances
		$widget_instances = array();
		foreach ( $available_widgets as $widget_data ) {
			$widget_instances[$widget_data['id_base']] = get_option( 'widget_' . $widget_data['id_base'] );
		}
		// Begin results
		$results = array();
		// Loop import data's sidebars
		foreach ( $data as $sidebar_id => $widgets ) {
			// Skip inactive widgets
			// (should not be in export file)
			if ( 'wp_inactive_widgets' == $sidebar_id ) {
				continue;
			}
			// Check if sidebar is available on this site
			// Otherwise add widgets to inactive, and say so
			if ( isset( $wp_registered_sidebars[$sidebar_id] ) ) {
				$sidebar_available = true;
				$use_sidebar_id = $sidebar_id;
				$sidebar_message_type = 'success';
				$sidebar_message = '';
			} else {
				$sidebar_available = false;
				$use_sidebar_id = 'wp_inactive_widgets'; // add to inactive if sidebar does not exist in theme
				$sidebar_message_type = 'error';
				$sidebar_message = esc_html__( 'Sidebar does not exist in theme (using Inactive)', 'mist' );
			}
			// Result for sidebar
			$results[$sidebar_id]['name'] = ! empty( $wp_registered_sidebars[$sidebar_id]['name'] ) ? $wp_registered_sidebars[$sidebar_id]['name'] : $sidebar_id; // sidebar name if theme supports it; otherwise ID
			$results[$sidebar_id]['message_type'] = $sidebar_message_type;
			$results[$sidebar_id]['message'] = $sidebar_message;
			$results[$sidebar_id]['widgets'] = array();
			// Loop widgets
			foreach ( $widgets as $widget_instance_id => $widget ) {
				$fail = false;
				// Get id_base (remove -# from end) and instance ID number
				$id_base = preg_replace( '/-[0-9]+$/', '', $widget_instance_id );
				$instance_id_number = str_replace( $id_base . '-', '', $widget_instance_id );
				// Does site support this widget?
				if ( ! $fail && ! isset( $available_widgets[$id_base] ) ) {
					$fail = true;
					$widget_message_type = 'error';
					$widget_message = esc_html__( 'Site does not support widget', 'mist' ); // explain why widget not imported
				}
				// Does widget with identical settings already exist in same sidebar?
				if ( ! $fail && isset( $widget_instances[$id_base] ) ) {
					// Get existing widgets in this sidebar
					$sidebars_widgets = get_option( 'sidebars_widgets' );
					$sidebar_widgets = isset( $sidebars_widgets[$use_sidebar_id] ) ? $sidebars_widgets[$use_sidebar_id] : array(); // check Inactive if that's where will go
					// Loop widgets with ID base
					$single_widget_instances = ! empty( $widget_instances[$id_base] ) ? $widget_instances[$id_base] : array();
					foreach ( $single_widget_instances as $check_id => $check_widget ) {
						// Is widget in same sidebar and has identical settings?
						if ( in_array( "$id_base-$check_id", $sidebar_widgets ) && (array) $widget == $check_widget ) {
							$fail = true;
							$widget_message_type = 'warning';
							$widget_message = esc_html__( 'Widget already exists', 'mist' ); // explain why widget not imported
							break;
						}
					}
				}
				// No failure
				if ( ! $fail ) {
					// Add widget instance
					$single_widget_instances = get_option( 'widget_' . $id_base ); // all instances for that widget ID base, get fresh every time
					$single_widget_instances = ! empty( $single_widget_instances ) ? $single_widget_instances : array( '_multiwidget' => 1 ); // start fresh if have to
					$single_widget_instances[] = (array) $widget; // add it
						// Get the key it was given
						end( $single_widget_instances );
						$new_instance_id_number = key( $single_widget_instances );
						// If key is 0, make it 1
						// When 0, an issue can occur where adding a widget causes data from other widget to load, and the widget doesn't stick (reload wipes it)
						if ( '0' === strval( $new_instance_id_number ) ) {
							$new_instance_id_number = 1;
							$single_widget_instances[$new_instance_id_number] = $single_widget_instances[0];
							unset( $single_widget_instances[0] );
						}
						// Move _multiwidget to end of array for uniformity
						if ( isset( $single_widget_instances['_multiwidget'] ) ) {
							$multiwidget = $single_widget_instances['_multiwidget'];
							unset( $single_widget_instances['_multiwidget'] );
							$single_widget_instances['_multiwidget'] = $multiwidget;
						}
						// Update option with new widget
						update_option( 'widget_' . $id_base, $single_widget_instances );
					// Assign widget instance to sidebar
					$sidebars_widgets = get_option( 'sidebars_widgets' ); // which sidebars have which widgets, get fresh every time
					$new_instance_id = $id_base . '-' . $new_instance_id_number; // use ID number from new widget instance
					$sidebars_widgets[$use_sidebar_id][] = $new_instance_id; // add new instance to sidebar
					update_option( 'sidebars_widgets', $sidebars_widgets ); // save the amended data
					// Success message
					if ( $sidebar_available ) {
						$widget_message_type = 'success';
						$widget_message = esc_html__( 'success', 'mist' );
					} else {
						$widget_message_type = 'warning';
						$widget_message = esc_html__( 'Imported to Inactive', 'mist' );
					}
				}
				// Result for widget instance
				$results[$sidebar_id]['widgets'][$widget_instance_id]['name'] = isset( $available_widgets[$id_base]['name'] ) ? $available_widgets[$id_base]['name'] : $id_base; // widget name or ID if name not available (not supported by site)
				$results[$sidebar_id]['widgets'][$widget_instance_id]['title'] = ! empty( $widget->title ) ? $widget->title : esc_html__( 'No Title', 'mist' ); // show "No Title" if widget instance is untitled
				$results[$sidebar_id]['widgets'][$widget_instance_id]['message_type'] = $widget_message_type;
				$results[$sidebar_id]['widgets'][$widget_instance_id]['message'] = $widget_message;
			}
		}
		// Return results
		return $results;
	}
	
	public function zozo_import_custom_sidebars( $file ){
        $sidebars = $this->zozo_import_get_file( $file );
		if( isset( $sidebars ) && $sidebars ) {
			update_option( 'sbg_sidebars', $sidebars );
	
			foreach( $sidebars as $sidebar ) {
				$sidebar_class = zozo_name_to_class( $sidebar );
				
				register_sidebar(array(
					'name'			=>	$sidebar,
					'id'			=> 'zozo-custom-'.strtolower($sidebar_class),
					'before_widget' => '<div id="%1$s" class="widget %2$s">',
					'after_widget' 	=> '</div>',
					'before_title' 	=> '<h3 class="widget-title">',
					'after_title'	=> '</h3>',
				));
			}
        	$this->message = __("Custom sidebars imported successfully", "mist");
		}
    }
	
	public function zozo_import_sidebars_widgets( $file ){
		$response = wp_remote_get( 'http://zozothemes.com/wp/mist/extras/importer/widgets.json' );
		$widgets_json = wp_remote_retrieve_body( $response );
		$widgets_file = $widgets_json ? json_decode( $widgets_json, true ) : '';
        // Add Widgets
		if( !empty( $widgets_file ) ) {
			self::zozo_widgets_import_process( $widgets_file );
		}        
    }
	
	public function zozo_import_theme_options( $file ){
		$file_contents = $this->zozo_import_get_file( $file );
		$theme_options = json_decode($file_contents, true);
		$redux = ReduxFrameworkInstances::get_instance('zozo_options');
		$redux->set_options($theme_options);
		zozo_save_theme_options();
        $this->message = __("Options imported successfully", "mist");
    }
	
	public function zozo_import_menus(){
		/* Set imported menus to Registered Menu locations in Theme */
				
		// Registered Menu Locations in Theme
		$locations = get_theme_mod( 'nav_menu_locations' );
		// Get Registered menus
		$menus = wp_get_nav_menus();
		
		// Assign menus to theme locations 
		if( is_array($menus) ) {
			foreach( $menus as $menu ) {
				if( $menu->name == 'Main Menu' ) {
					$locations['primary-menu'] = $menu->term_id;
				} else if( $menu->name == 'Main Menu Right' ) {
					$locations['primary-right'] = $menu->term_id;
				} else if( $menu->name == 'Top Menu' ) {
					$locations['top-menu'] = $menu->term_id;
				} else if( $menu->name == 'Footer Menu' ) {
					$locations['footer-menu'] = $menu->term_id;
				}
			}
		}

		set_theme_mod( 'nav_menu_locations', $locations );
    }
	
	public function zozo_import_settings_pages(){
		// Set Woocommerce Pages
		$woo_pages = array(
			'woocommerce_shop_page_id' => 'Shop',
			'woocommerce_cart_page_id' => 'Cart',
			'woocommerce_checkout_page_id' => 'Checkout',
			'woocommerce_myaccount_page_id' => 'My Account'
		);
		
		foreach( $woo_pages as $woo_page_name => $woo_page_title ) {
			$woo_page = get_page_by_title( $woo_page_title );
			if( isset( $woo_page ) && $woo_page->ID ) {
				update_option($woo_page_name, $woo_page->ID);
			}
		}
    }
	
	public function zozo_import_revslider( $demo_type, $file ){
		// Import Revolution Slider
		$wp_filesystem = self::mist_credentials();
		if( class_exists( 'RevSlider' ) && $file ) {
			
			require_once ABSPATH . 'wp-load.php';
			require_once ABSPATH . 'wp-includes/functions.php';
			
			$sliders_from = mist_get_server_files( "http://zozothemes.com/wp/mist/extras/importer/" . $file );
			$sliders_to =  ZOZOINCLUDES . 'plugins/importer/data/slider-'.$demo_type.'.zip';
			if( $wp_filesystem->put_contents( $sliders_to, $sliders_from, FS_CHMOD_FILE ) ) :
				$slider = new RevSlider();			
				$slider->importSliderFromPost( true, true, $sliders_to );
			endif;
			
		}
    }

	public function zozo_import_get_file( $file ){
        $file_content = "";
        $file_for_import = ZOZOINCLUDES . 'plugins/importer/data/' . $file;
        $file_content = $this->zozo_get_file_contents( $file );
        if( $file_content ) {
			$b64d = 'base6'.'4_dec'.'ode';
            $unserialized_content = unserialize($b64d($file_content));
            if( $unserialized_content ) {	
                return $unserialized_content;
            }
        }
        return false;
    }
	
	function zozo_get_file_contents( $path ) {
		$url      = "http://zozothemes.com/wp/mist/extras/importer/" . $path;
		$response = wp_remote_get($url);
		$body     = wp_remote_retrieve_body($response);
		return $body;
    }

}

global $zozo_import;
$zozo_import = new Zozo_Import();
 
/* ================================================
 * Ajax Hook for Importer
 * ================================================ */
 
if( ! function_exists('zozo_demo_content_importer') ) {
    function zozo_demo_content_importer() {

       // global $zozo_import;
	   $zozo_import = new Zozo_Import();
		
		if( ! isset( $_POST['demo_type'] ) || trim( $_POST['demo_type'] ) == '' ) {
			$demo_type = 'demo-multi-classic';
		} else {
			$demo_type = $_POST['demo_type'];
		}
		
		if( ! empty($_POST['demo_type'] )) {
			if( class_exists('Woocommerce') && $_POST['woo_demo'] == 'yes' ) {
				$folder = $_POST['demo_type'] . "/themewithwoo.xml";
			} else {
           		$folder = $_POST['demo_type'] . "/theme.xml";
			}
		}
		
        $zozo_import->zozo_import_content($folder);
		if( class_exists('Woocommerce') && $_POST['woo_demo'] == 'yes' ) {
			$zozo_import->zozo_import_settings_pages();
		}

		// Reading settings
		$home_page_title = 'Home';
		
		// Set reading options
		$home_page = get_page_by_title( $home_page_title );
		if( isset( $home_page ) && $home_page->ID ) {
			update_option( 'show_on_front', 'page' );
			update_option( 'page_on_front', $home_page->ID ); // Front Page
		}

        echo "imported";
		die();
    }

    add_action('wp_ajax_zozo_import_demo_data', 'zozo_demo_content_importer');
}

if( ! function_exists('zozo_demo_import_other_data') ) {
    function zozo_demo_import_other_data() {
	
        //global $zozo_import;
		$zozo_import = new Zozo_Import();
		
		if( ! isset( $_POST['demo_type'] ) || trim( $_POST['demo_type'] ) == '' ) {
			$demo_type = 'demo-multi-classic';
		} else {
			$demo_type = $_POST['demo_type'];
		}
        $folder = $demo_type . "/";
		
		$zozo_import->zozo_import_theme_options( $folder.'theme-options.txt' );
		$zozo_import->zozo_import_menus();
        $zozo_import->zozo_import_widgets( $folder.'widgets.txt', $folder.'custom_sidebars.txt' );
		if( isset( $_POST['rev_slider'] ) && $_POST['rev_slider'] == 'yes' ) {
			$zozo_import->zozo_import_revslider( $demo_type, $folder.'rev_slider.zip' );
		}

        echo "imported";
		die();
    }

    add_action('wp_ajax_zozo_import_demo_other_data', 'zozo_demo_import_other_data');
}

// Get Class
function zozo_name_to_class( $name ){
	$class = str_replace(array(' ',',','.','"',"'",'/',"\\",'+','=',')','(','*','&','^','%','$','#','@','!','~','`','<','>','?','[',']','{','}','|',':',),'',$name);
	$class = sanitize_html_class($class);
	return $class;
}

/* ================================================
 * Parsing Widgets Function
 * ================================================ */
// Thanks to http://wordpress.org/plugins/widget-settings-importexport/
function zozo_import_widget_data( $widget_data ) {
	$json_data = $widget_data;
	$json_data = json_decode( $json_data, true );
	$sidebar_data = $json_data[0];
	$widget_data = $json_data[1];
	
	foreach ( $widget_data as $widget_data_title => $widget_data_value ) {
		$widgets[ $widget_data_title ] = '';
		foreach( $widget_data_value as $widget_data_key => $widget_data_array ) {
			if( is_int( $widget_data_key ) ) {
				$widgets[$widget_data_title][$widget_data_key] = 'on';
			}
		}
	}
	unset($widgets[""]);

	foreach ( $sidebar_data as $title => $sidebar ) {
		$count = count( $sidebar );
		for ( $i = 0; $i < $count; $i++ ) {
			$widget = array( );
			$widget['type'] = trim( substr( $sidebar[$i], 0, strrpos( $sidebar[$i], '-' ) ) );
			$widget['type-index'] = trim( substr( $sidebar[$i], strrpos( $sidebar[$i], '-' ) + 1 ) );
			if ( !isset( $widgets[$widget['type']][$widget['type-index']] ) ) {
				unset( $sidebar_data[$title][$i] );
			}
		}
		$sidebar_data[$title] = array_values( $sidebar_data[$title] );
	}

	foreach ( $widgets as $widget_title => $widget_value ) {
		foreach ( $widget_value as $widget_key => $widget_value ) {
			$widgets[$widget_title][$widget_key] = $widget_data[$widget_title][$widget_key];
		}
	}

	$sidebar_data = array( array_filter( $sidebar_data ), $widgets );

	zozo_parse_import_data( $sidebar_data );
}

/**
 * Import widgets
 * @param array $import_array
 */
function zozo_parse_import_data( $import_array ) {
	global $wp_registered_sidebars;
	
	$sidebars_data = $import_array[0];
	$widget_data = $import_array[1];
	$current_sidebars = get_option( 'sidebars_widgets' );
	$new_widgets = array( );

	foreach ( $sidebars_data as $import_sidebar => $import_widgets ) :

		foreach ( $import_widgets as $import_widget ) :
			//if the sidebar exists
			if ( isset( $wp_registered_sidebars[$import_sidebar] ) ) :
				$title = trim( substr( $import_widget, 0, strrpos( $import_widget, '-' ) ) );
				$index = trim( substr( $import_widget, strrpos( $import_widget, '-' ) + 1 ) );
				$current_widget_data = get_option( 'widget_' . $title );
				$new_widget_name = zozo_get_new_widget_name( $title, $index );
				$new_index = trim( substr( $new_widget_name, strrpos( $new_widget_name, '-' ) + 1 ) );

				if ( !empty( $new_widgets[ $title ] ) && is_array( $new_widgets[$title] ) ) {
					while ( array_key_exists( $new_index, $new_widgets[$title] ) ) {
						$new_index++;
					}
				}
				$current_sidebars[$import_sidebar][] = $title . '-' . $new_index;
				if ( array_key_exists( $title, $new_widgets ) ) {
					$new_widgets[$title][$new_index] = $widget_data[$title][$index];
					$multiwidget = $new_widgets[$title]['_multiwidget'];
					unset( $new_widgets[$title]['_multiwidget'] );
					$new_widgets[$title]['_multiwidget'] = $multiwidget;
				} else {
					$current_widget_data[$new_index] = $widget_data[$title][$index];
					$current_multiwidget = isset($current_widget_data['_multiwidget']) ? $current_widget_data['_multiwidget'] : false;
					$new_multiwidget = isset($widget_data[$title]['_multiwidget']) ? $widget_data[$title]['_multiwidget'] : false;
					$multiwidget = ($current_multiwidget != $new_multiwidget) ? $current_multiwidget : 1;
					unset( $current_widget_data['_multiwidget'] );
					$current_widget_data['_multiwidget'] = $multiwidget;
					$new_widgets[$title] = $current_widget_data;
				}

			endif;
		endforeach;
	endforeach;

	if ( isset( $new_widgets ) && isset( $current_sidebars ) ) {
		update_option( 'sidebars_widgets', $current_sidebars );

		foreach ( $new_widgets as $title => $content )
			update_option( 'widget_' . $title, $content );

		return true;
	}

	return false;
}

function zozo_get_new_widget_name( $widget_name, $widget_index ) {
	$current_sidebars = get_option( 'sidebars_widgets' );
	$all_widget_array = array( );
	foreach ( $current_sidebars as $sidebar => $widgets ) {
		if ( !empty( $widgets ) && is_array( $widgets ) && $sidebar != 'wp_inactive_widgets' ) {
			foreach ( $widgets as $widget ) {
				$all_widget_array[] = $widget;
			}
		}
	}
	while ( in_array( $widget_name . '-' . $widget_index, $all_widget_array ) ) {
		$widget_index++;
	}
	$new_widget_name = $widget_name . '-' . $widget_index;
	return $new_widget_name;
}