<?php

/**
 * Enqueue Google Web Fonts.
 */

function mist_default_fonts_url() {
    $font_url = '';
    
    /*
    Translators: If there are characters in your language that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own language.
     */
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'mist' ) ) {
        $font_url = add_query_arg( 'family', urlencode( 'Arimo:400,700,400italic,700italic|Oswald:200,300,400,500,600,700&subset=latin,latin-ext' ), "//fonts.googleapis.com/css" );
    }
    return $font_url;
}
 
function mist_enqueue_google_web_fonts() {
	wp_enqueue_style( 'google-fonts', mist_default_fonts_url(), array(), null, 'all' );
}

add_action( 'wp_enqueue_scripts', 'mist_enqueue_google_web_fonts' );

global $zozo_options;
$zozo_options = get_option('zozo_options');

function mist_default_theme_options(){	
	$cur_theme = wp_get_theme();	
	if ( $cur_theme->get( 'Name' ) == 'Mist' || $cur_theme->get( 'Name' ) == 'Mist Child' ){
		$zozo_opt = get_option('zozo_options');
		if( !$zozo_opt ){
			$input_val = mist_default_theme_values();	
			$zozo_options = json_decode( $input_val, true );
			$zozo_options['zozo_logo']['url'] = ZOZOTHEME_URL . '/images/logo.png';
			$zozo_options['zozo_sticky_logo']['url'] = ZOZOTHEME_URL . '/images/sticky-logo.png';
			update_option( 'zozo_options', $zozo_options );
		}
		zozo_save_theme_options();
	}
}
add_action("after_switch_theme", "mist_default_theme_options", 10);


function mist_default_theme_values(){
	$theme_opt_def =  '{"last_tab":"","zozo_disable_page_loader":"","zozo_enable_responsive":"1","zozo_enable_rtl_mode":"","zozo_enable_breadcrumbs":"1","zozo_disable_opengraph":"","zozo_logo":{"url":"","id":"11002","height":"35","width":"133","thumbnail":""},"zozo_logo_padding":{"padding-top":"","padding-right":"","padding-bottom":"","padding-left":"","units":"px"},"zozo_sticky_logo":{"url":"","id":"11002","height":"35","width":"133","thumbnail":""},"zozo_sticky_logo_padding":{"padding-top":"","padding-right":"","padding-bottom":"","padding-left":"","units":"px"},"zozo_google_map_api":"","zozo_mailchimp_api":"","zozo_custom_css":".theme-features-list .zozo-feature-box.style-default-box .grid-text-left .grid-icon-wrapper {\r\n    padding-right: 30px;\r\n}\r\n.theme-features-list .grid-desc > p {\r\n    color: #555;\r\n}\r\n.theme-features-list .vc-inner-row-section{\r\n     margin-bottom: 40px;\r\n}\r\n.btn-rev-slider:hover a, .btn-rev-slider a:focus{\r\n    color: #ffc400;\r\n}\r\n.vc-match-height-inner-row .vc_column_inner {\r\n    height: 100% !important;\r\n}\r\n\/* Responsive *\/\r\n@media only screen and (max-width:1024px) and (min-width:768px) {\r\n    .hero-title {\r\n        font-size: 24px !important;\r\n    }\r\n}","zozo_enable_maintenance":"0","zozo_maintenance_mode_page":"","zozo_enable_coming_soon":"0","zozo_coming_soon_page":"","zozo_theme_layout":"fullwidth","zozo_layout":"one-col","zozo_fullwidth_site_width":"1200","zozo_boxed_site_width":"1200","zozo_header_layout":"fullwidth","zozo_sticky_header":"1","zozo_enable_search_in_header":"1","zozo_show_socials_header":"1","zozo_show_cart_header":"1","zozo_header_skin":"light","zozo_header_transparency":"no-transparent","zozo_header_type":"header-1","zozo_slider_position":"below","zozo_header_toggle_position":"left","zozo_header_side_width":"280px","zozo_enable_header_top_bar":"1","zozo_welcome_msg":"Welcome to Mist","zozo_header_phone":"+12 123 456 789","zozo_header_email":"info@yoursite.com","zozo_header_address":"<strong>No. 12, Ribon Building, <\/strong><span>Walse street, Australia.<\/span>","zozo_header_business_hours":"<strong>Monday-Friday: 9am to 5pm <\/strong><span>Saturday \/ Sunday: Closed<\/span>","zozo_enable_sliding_bar":"1","zozo_disable_sliding_bar":"1","zozo_sliding_bar_columns":"3","zozo_header_spacing":{"padding-top":"","padding-right":"","padding-bottom":"","padding-left":"","units":"px"},"zozo_menu_type":"megamenu","zozo_dropdown_menu_width":{"width":"200px","units":"px"},"zozo_menu_height":{"height":"76px","units":"px"},"zozo_sticky_menu_height":{"height":"60px","units":"px"},"zozo_logo_bar_height":{"height":"76px","units":"px"},"zozo_menu_height_alt":{"height":"60px","units":"px"},"zozo_sticky_menu_height_alt":{"height":"60px","units":"px"},"zozo_enable_secondary_menu":"","zozo_secondary_menu_position":"right","zozo_mobile_logo":{"url":"","id":"","height":"","width":"","thumbnail":""},"zozo_sticky_mobile_header":"1","zozo_copyright_text":"&copy; Copyright 2019. Designed By <a href=\"http:\/\/ventureharbour.com\/\">Venture Harbour<\/a> \/ <a href=\"http:\/\/zozothemes.com\/\">zozothemes<\/a>   ","zozo_footer_widgets_enable":"1","zozo_enable_back_to_top":"1","zozo_enable_footer_menu":"1","zozo_footer_skin":"light","zozo_footer_style":"default","zozo_footer_type":"footer-1","zozo_footer_spacing":{"padding-top":"","padding-right":"","padding-bottom":"","padding-left":"","units":"px"},"zozo_footer_copyright_spacing":{"padding-top":"","padding-right":"","padding-bottom":"","padding-left":"","units":"px"},"zozo_body_font":{"font-family":"Arimo","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","font-size":"14px","line-height":"25px","color":"#333333"},"zozo_h1_font_styles":{"font-family":"Oswald","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","font-size":"48px","line-height":"62px","color":""},"zozo_h2_font_styles":{"font-family":"Oswald","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","font-size":"40px","line-height":"52px","color":""},"zozo_h3_font_styles":{"font-family":"Oswald","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","font-size":"32px","line-height":"42px","color":""},"zozo_h4_font_styles":{"font-family":"Oswald","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","font-size":"24px","line-height":"31px","color":""},"zozo_h5_font_styles":{"font-family":"Oswald","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","font-size":"18px","line-height":"23px","color":""},"zozo_h6_font_styles":{"font-family":"Oswald","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","font-size":"16px","line-height":"21px","color":""},"zozo_top_menu_font_styles":{"font-family":"Arimo","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","font-size":"12px","line-height":"12px","color":""},"zozo_menu_font_styles":{"font-family":"Arimo","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","font-size":"14px","color":""},"zozo_submenu_font_styles":{"font-family":"Arimo","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","font-size":"14px","line-height":"20px","color":""},"zozo_single_post_title_fonts":{"font-family":"Oswald","font-options":"","google":"1","font-weight":"400","font-style":"normal","subsets":"","font-size":"36px","line-height":"50px","color":""},"zozo_post_title_font_styles":{"font-family":"Oswald","font-options":"","google":"1","font-weight":"400","font-style":"normal","subsets":"","font-size":"26px","line-height":"41px","color":""},"zozo_widget_title_fonts":{"font-family":"Oswald","font-options":"","google":"1","font-weight":"400","font-style":"normal","subsets":"","font-size":"16px","line-height":"42px","color":""},"zozo_widget_text_fonts":{"font-family":"Arimo","font-options":"","google":"1","font-weight":"400","font-style":"normal","subsets":"","font-size":"13px","line-height":"25px","color":""},"zozo_footer_widget_title_fonts":{"font-family":"Oswald","font-options":"","google":"1","font-weight":"400","font-style":"normal","subsets":"","font-size":"16px","line-height":"42px","color":""},"zozo_footer_widget_text_fonts":{"font-family":"Arimo","font-options":"","google":"1","font-weight":"400","font-style":"normal","subsets":"","font-size":"13px","line-height":"25px","color":""},"zozo_color_scheme":"yellow.css","zozo_theme_skin":"light","zozo_custom_scheme_color":"#ffc400","zozo_custom_color_skin":{"regular":"","hover":""},"zozo_link_color":{"regular":"","hover":""},"zozo_body_bg_image":{"background-color":"","background-repeat":"","background-size":"","background-attachment":"","background-position":"","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"zozo_page_bg_image":{"background-color":"","background-repeat":"","background-size":"","background-attachment":"","background-position":"","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"zozo_header_bg_image":{"background-color":"","background-repeat":"","background-size":"","background-attachment":"","background-position":"","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"zozo_sticky_bg_image":{"background-color":"","background-repeat":"","background-size":"","background-attachment":"","background-position":"","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"zozo_header_top_background_color":"","zozo_sliding_background_color":"","zozo_top_menu_hcolor":{"hover":""},"zozo_main_menu_hcolor":{"hover":"#ffc400"},"zozo_submenu_show_border":"1","zozo_main_submenu_border":{"border-top":"3px","border-right":"","border-bottom":"","border-left":"","border-style":"solid","border-color":""},"zozo_submenu_bg_color":"#ffffff","zozo_sub_menu_hcolor":{"hover":""},"zozo_submenu_hbg_color":"","zozo_footer_bg_image":{"background-color":"","background-repeat":"","background-size":"","background-attachment":"","background-position":"","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"zozo_footer_copy_bg_image":{"background-color":"","background-repeat":"","background-size":"","background-attachment":"","background-position":"","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"zozo_social_icon_type":"transparent","zozo_facebook_link":"#","zozo_twitter_link":"#","zozo_linkedin_link":"#","zozo_pinterest_link":"#","zozo_youtube_link":"#","zozo_rss_link":"#","zozo_tumblr_link":"","zozo_reddit_link":"","zozo_dribbble_link":"","zozo_digg_link":"","zozo_flickr_link":"","zozo_instagram_link":"","zozo_vimeo_link":"","zozo_skype_link":"","zozo_blogger_link":"","zozo_yahoo_link":"","zozo_portfolio_archive_count":"10","zozo_portfolio_archive_layout":"grid","zozo_portfolio_archive_columns":"4","zozo_portfolio_archive_gutter":"30","zozo_portfolio_prev_next":"1","zozo_portfolio_related_slider":"1","zozo_portfolio_related_title":"","zozo_portfolio_citems":"","zozo_portfolio_citems_scroll":"","zozo_portfolio_ctablet":"","zozo_portfolio_cmobile_land":"","zozo_portfolio_cmobile":"","zozo_portfolio_cmargin":"20","zozo_portfolio_cautoplay":"1","zozo_portfolio_ctimeout":"5000","zozo_portfolio_cloop":"","zozo_portfolio_cpagination":"1","zozo_portfolio_cnavigation":"","zozo_disable_blog_pagination":"","zozo_blog_read_more_text":"","zozo_blog_excerpt_length_large":"80","zozo_blog_excerpt_length_grid":"40","zozo_blog_slideshow_autoplay":"1","zozo_blog_slideshow_timeout":"5000","zozo_blog_date_format":"d.m.Y","zozo_blog_post_meta_author":"","zozo_blog_post_meta_date":"","zozo_blog_post_meta_categories":"","zozo_blog_post_meta_comments":"","zozo_blog_read_more":"","zozo_blog_archive_layout":"one-col","zozo_archive_blog_type":"large","zozo_archive_blog_grid_columns":"two","zozo_show_archive_featured_slider":"","zozo_blog_page_title_bar":"1","zozo_blog_title":"Blog","zozo_blog_slogan":"","zozo_blog_layout":"two-col-right","zozo_blog_type":"large","zozo_blog_grid_columns":"two","zozo_show_blog_featured_slider":"","zozo_single_post_layout":"one-col","zozo_blog_social_sharing":"1","zozo_blog_author_info":"1","zozo_blog_comments":"1","zozo_show_related_posts":"1","zozo_related_blog_items":"2","zozo_related_blog_items_scroll":"2","zozo_related_blog_autoplay":"1","zozo_related_blog_timeout":"5000","zozo_related_blog_loop":"1","zozo_related_blog_margin":"30","zozo_related_blog_tablet":"3","zozo_related_blog_landscape":"2","zozo_related_blog_portrait":"1","zozo_related_blog_dots":"","zozo_related_blog_nav":"1","zozo_blog_prev_next":"1","zozo_single_blog_carousel":"","zozo_single_blog_citems":"3","zozo_single_blog_citems_scroll":"1","zozo_single_blog_cautoplay":"1","zozo_single_blog_ctimeout":"5000","zozo_single_blog_cloop":"","zozo_single_blog_cmargin":"","zozo_single_blog_ctablet":"3","zozo_single_blog_cmlandscape":"2","zozo_single_blog_cmportrait":"1","zozo_single_blog_cdots":"","zozo_single_blog_cnav":"1","zozo_featured_slider_type":"below_header","zozo_featured_posts_limit":"6","zozo_featured_slider_citems":"3","zozo_featured_slider_citems_scroll":"1","zozo_featured_slider_cautoplay":"1","zozo_featured_slider_ctimeout":"5000","zozo_featured_slider_cloop":"","zozo_featured_slider_cmargin":"","zozo_featured_slider_ctablet":"3","zozo_featured_slider_cmlandscape":"2","zozo_featured_slider_cmportrait":"1","zozo_featured_slider_cdots":"","zozo_featured_slider_cnav":"1","zozo_search_page_type":"grid","zozo_search_grid_columns":"two","zozo_search_results_content":"both","zozo_sharing_facebook":"1","zozo_sharing_twitter":"1","zozo_sharing_linkedin":"1","zozo_sharing_pinterest":"","zozo_sharing_tumblr":"","zozo_sharing_reddit":"","zozo_sharing_digg":"","zozo_sharing_email":"1","zozo_contact_form_success":"Thank you {name}. Your Email was successfully sent!","zozo_contact_form_error":"Sorry {name}. Your Email was not sent. Resubmit form again Please..","zozo_woo_enable_catalog_mode":"","zozo_woo_archive_layout":"one-col","zozo_woo_single_layout":"two-col-right","zozo_loop_products_per_page":"12","zozo_loop_shop_columns":"4","zozo_related_products_count":"3","zozo_woo_shop_ordering":"1","zozo_woo_social_sharing":"1","zozo_enable_ultimate_icomoon1":"1","zozo_enable_ultimate_icomoon2":"1","zozo_enable_ultimate_icomoon3":"1","zozo_remove_scripts_version":"1","zozo_minify_css":"1","zozo_minify_js":"1","redux-backup":"1"}';

	return $theme_opt_def;
}